/*
 * Decompiled with CFR 0.152.
 */
package dev.lnkr.animalhusbandry;

import com.hypixel.hytale.component.ComponentType;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.system.ISystem;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.event.events.entity.EntityRemoveEvent;
import com.hypixel.hytale.server.core.modules.interaction.interaction.config.Interaction;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import dev.lnkr.animalhusbandry.breeding.AnimalBreedingService;
import dev.lnkr.animalhusbandry.breeding.AnimalHusbandryInteractionComponent;
import dev.lnkr.animalhusbandry.breeding.AnimalHusbandryUseGateInteraction;
import dev.lnkr.animalhusbandry.breeding.AnimalSpawnSystem;
import dev.lnkr.animalhusbandry.breeding.FeedAnimalInteraction;
import dev.lnkr.animalhusbandry.breeding.TamedAnimalComponent;
import dev.lnkr.animalhusbandry.config.ConfigStore;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class AnimalHusbandry
extends JavaPlugin {
    public static final HytaleLogger LOGGER = HytaleLogger.forEnclosingClass();
    private static final long[] STARTUP_SCAN_DELAYS_MS = new long[]{1000L, 5000L, 15000L};
    private static AnimalHusbandry instance;
    private ConfigStore.Config config;
    private AnimalBreedingService breedingService;
    private ScheduledExecutorService scheduler;
    private ComponentType<EntityStore, TamedAnimalComponent> tamedComponentType;
    private ComponentType<EntityStore, AnimalHusbandryInteractionComponent> interactionComponentType;

    public AnimalHusbandry(@Nonnull JavaPluginInit init) {
        super(init);
        instance = this;
    }

    public static AnimalHusbandry getInstance() {
        return instance;
    }

    public AnimalBreedingService getBreedingService() {
        return this.breedingService;
    }

    public boolean isTrackedModel(String modelAssetId) {
        return this.breedingService != null && this.breedingService.isTrackedModel(modelAssetId);
    }

    protected void setup() {
        ((HytaleLogger.Api)LOGGER.atInfo()).log("AnimalHusbandry setup starting");
        ConfigStore.LoadedConfig loaded = ConfigStore.loadOrCreate(this.getDataDirectory(), LOGGER);
        this.config = loaded.config;
        this.tamedComponentType = this.getEntityStoreRegistry().registerComponent(TamedAnimalComponent.class, "AnimalHusbandry:TamedAnimal", TamedAnimalComponent.CODEC);
        this.interactionComponentType = this.getEntityStoreRegistry().registerComponent(AnimalHusbandryInteractionComponent.class, "AnimalHusbandry:InteractionGate", AnimalHusbandryInteractionComponent.CODEC);
        this.breedingService = new AnimalBreedingService(LOGGER, this.config, loaded.preset, this.tamedComponentType, this.interactionComponentType);
        try {
            this.getCodecRegistry(Interaction.CODEC).register("AnimalHusbandry_FeedAnimal", FeedAnimalInteraction.class, FeedAnimalInteraction.CODEC);
            ((HytaleLogger.Api)LOGGER.atInfo()).log("Registered AnimalHusbandry_FeedAnimal interaction codec");
        }
        catch (Exception e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("AnimalHusbandry_FeedAnimal interaction codec already registered");
        }
        try {
            this.getCodecRegistry(Interaction.CODEC).register("AnimalHusbandry_UseGate", AnimalHusbandryUseGateInteraction.class, AnimalHusbandryUseGateInteraction.CODEC);
            ((HytaleLogger.Api)LOGGER.atInfo()).log("Registered AnimalHusbandry_UseGate interaction codec");
        }
        catch (Exception e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("AnimalHusbandry_UseGate interaction codec already registered");
        }
        this.getEventRegistry().registerGlobal(EntityRemoveEvent.class, event -> {
            Store store;
            if (this.breedingService == null || event.getEntity() == null) {
                return;
            }
            Ref ref = event.getEntity().getReference();
            if (ref != null && (store = ref.getStore()) != null) {
                this.breedingService.onEntityRemoved((Ref<EntityStore>)ref, (Store<EntityStore>)store);
            }
        });
    }

    protected void start() {
        if (this.breedingService == null || !this.breedingService.isEnabled()) {
            ((HytaleLogger.Api)LOGGER.atWarning()).log("Breeding disabled; skipping start");
            return;
        }
        this.getEntityStoreRegistry().registerSystem((ISystem)new AnimalSpawnSystem(this));
        ((HytaleLogger.Api)LOGGER.atInfo()).log("Animal spawn system registered (%d animals)", this.breedingService.getAnimalCount());
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        long tickIntervalMillis = this.getTickIntervalMillis();
        this.scheduler.scheduleAtFixedRate(this::tick, tickIntervalMillis, tickIntervalMillis, TimeUnit.MILLISECONDS);
        World world = Universe.get().getDefaultWorld();
        if (world != null) {
            this.scheduleInitialScan(world);
        } else {
            ((HytaleLogger.Api)LOGGER.atWarning()).log("Default world not ready; animal scan deferred");
        }
    }

    protected void shutdown() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
    }

    public void onAnimalSpawn(Ref<EntityStore> ref, String modelAssetId) {
        World world = Universe.get().getDefaultWorld();
        if (world == null || ref == null) {
            return;
        }
        world.execute(() -> {
            Store store = world.getEntityStore().getStore();
            this.breedingService.handleEntity((Store<EntityStore>)store, ref, modelAssetId);
        });
    }

    private void scheduleInitialScan(World world) {
        long[] lArray = STARTUP_SCAN_DELAYS_MS;
        int n = STARTUP_SCAN_DELAYS_MS.length;
        int n2 = 0;
        while (n2 < n) {
            long delayMillis = lArray[n2];
            this.scheduler.schedule(() -> world.execute(() -> this.scanForAnimals(world)), delayMillis, TimeUnit.MILLISECONDS);
            ++n2;
        }
    }

    private void scanForAnimals(World world) {
        if (this.breedingService == null) {
            return;
        }
        Store store = world.getEntityStore().getStore();
        int count = this.breedingService.scanLoadedAnimals((Store<EntityStore>)store);
        ((HytaleLogger.Api)LOGGER.atInfo()).log("Animal scan complete: %d entities", count);
    }

    private void tick() {
        World world = Universe.get().getDefaultWorld();
        if (world == null || this.breedingService == null) {
            return;
        }
        this.breedingService.tick(world);
    }

    private long getTickIntervalMillis() {
        if (this.config == null || this.config.global == null) {
            return 1000L;
        }
        double seconds = this.config.global.tickIntervalSeconds;
        if (seconds <= 0.0) {
            return 1000L;
        }
        long millis = (long)(seconds * 1000.0);
        return Math.max(1L, millis);
    }
}

