/*
 * Decompiled with CFR 0.152.
 */
package dev.lnkr.animalhusbandry.breeding;

import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Component;
import com.hypixel.hytale.component.ComponentType;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.RemoveReason;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.protocol.InteractionType;
import com.hypixel.hytale.server.core.entity.InteractionContext;
import com.hypixel.hytale.server.core.entity.UUIDComponent;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.movement.MovementStatesComponent;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.modules.entity.component.Interactable;
import com.hypixel.hytale.server.core.modules.entity.component.ModelComponent;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.modules.interaction.Interactions;
import com.hypixel.hytale.server.core.universe.world.ParticleUtil;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.npc.NPCPlugin;
import com.hypixel.hytale.server.npc.entities.NPCEntity;
import com.hypixel.hytale.server.npc.role.Role;
import com.hypixel.hytale.server.spawning.world.component.WorldSpawnData;
import dev.lnkr.animalhusbandry.breeding.AnimalHusbandryInteractionComponent;
import dev.lnkr.animalhusbandry.breeding.TamedAnimalComponent;
import dev.lnkr.animalhusbandry.config.ConfigStore;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public final class AnimalBreedingService {
    public static final String FEED_ROOT_ID = "Root_AnimalHusbandry_FeedAnimal";
    public static final String USE_GATE_ROOT_ID = "Root_AnimalHusbandry_UseGate";
    private static final String DEFAULT_FALLBACK_USE_ROOT = "*UseNPC";
    private static final String HEARTS_PARTICLE = "BreedingHearts";
    private static final double BABY_FEED_GROWTH_FRACTION = 0.1;
    private final HytaleLogger logger;
    private final ConfigStore.Config config;
    private final Map<String, AnimalDefinition> animalsByKey = new HashMap<String, AnimalDefinition>();
    private final Map<String, ModelEntry> modelIndex = new HashMap<String, ModelEntry>();
    private final Set<String> allBreedingFoods = new HashSet<String>();
    private final Map<UUID, AnimalState> animalStates = new ConcurrentHashMap<UUID, AnimalState>();
    private final Set<Ref<EntityStore>> pendingInteractionRefs = ConcurrentHashMap.newKeySet();
    private final ComponentType<EntityStore, TamedAnimalComponent> tamedComponentType;
    private final ComponentType<EntityStore, AnimalHusbandryInteractionComponent> interactionComponentType;
    private long lastCleanupMillis;
    private long lastFollowUpdateMillis;
    private long lastInteractionScanMillis;

    public AnimalBreedingService(HytaleLogger logger, ConfigStore.Config config, ConfigStore.Preset preset, ComponentType<EntityStore, TamedAnimalComponent> tamedComponentType, ComponentType<EntityStore, AnimalHusbandryInteractionComponent> interactionComponentType) {
        this.logger = logger;
        this.config = config;
        this.tamedComponentType = tamedComponentType;
        this.interactionComponentType = interactionComponentType;
        this.loadAnimals(preset);
    }

    public boolean isEnabled() {
        return !this.animalsByKey.isEmpty();
    }

    public int getAnimalCount() {
        return this.animalsByKey.size();
    }

    public boolean isTrackedModel(String modelAssetId) {
        return this.getModelEntry(modelAssetId) != null;
    }

    public void handleEntity(Store<EntityStore> store, Ref<EntityStore> ref, String modelAssetId) {
        if (!this.isEnabled()) {
            return;
        }
        ModelEntry entry = this.getModelEntry(modelAssetId);
        if (entry == null) {
            return;
        }
        if (entry.isBaby) {
            this.attachInteraction(store, ref);
            this.registerBaby(store, ref, entry.animal);
            return;
        }
        this.attachInteraction(store, ref);
        if (this.hasTamedComponent(store, ref)) {
            this.ensureTamedState(store, ref, entry.animal, false);
        } else if (this.isFollowEnabled()) {
            this.registerAdult(store, ref, entry.animal);
        }
    }

    public void attachInteraction(Store<EntityStore> store, Ref<EntityStore> ref) {
        if (!this.isEnabled()) {
            return;
        }
        if (ref == null || !ref.isValid()) {
            return;
        }
        Interactions interactions = (Interactions)store.getComponent(ref, Interactions.getComponentType());
        if (interactions == null) {
            interactions = (Interactions)store.ensureAndGetComponent(ref, Interactions.getComponentType());
        }
        if (interactions == null) {
            this.logDebug("Skipping entity without Interactions component: %s", ref);
            this.pendingInteractionRefs.add(ref);
            return;
        }
        String current = interactions.getInteractionId(InteractionType.Use);
        this.ensureInteractionGateComponent(store, ref, current);
        store.ensureAndGetComponent(ref, Interactable.getComponentType());
        if (!USE_GATE_ROOT_ID.equals(current)) {
            interactions.setInteractionId(InteractionType.Use, USE_GATE_ROOT_ID);
            store.putComponent(ref, Interactions.getComponentType(), (Component)interactions);
            this.logDebug("Attached %s to entity %s", USE_GATE_ROOT_ID, ref);
        }
    }

    public boolean shouldHandleFeed(InteractionContext context, Ref<EntityStore> targetRef) {
        if (!this.isEnabled() || context == null || targetRef == null || !targetRef.isValid()) {
            return false;
        }
        Store store = targetRef.getStore();
        if (store == null) {
            return false;
        }
        ModelComponent model = (ModelComponent)store.getComponent(targetRef, ModelComponent.getComponentType());
        if (model == null || model.getModel() == null) {
            return false;
        }
        ModelEntry entry = this.getModelEntry(model.getModel().getModelAssetId());
        if (entry == null) {
            return false;
        }
        ItemStack heldItem = context.getHeldItem();
        String itemId = heldItem != null ? heldItem.getItemId() : null;
        return entry.animal.isBreedingFood(itemId);
    }

    public String getFallbackUseInteractionId(Ref<EntityStore> targetRef) {
        String fallback;
        if (targetRef == null || !targetRef.isValid()) {
            return null;
        }
        Store store = targetRef.getStore();
        if (store == null || this.interactionComponentType == null) {
            return null;
        }
        AnimalHusbandryInteractionComponent component = (AnimalHusbandryInteractionComponent)store.getComponent(targetRef, this.interactionComponentType);
        String string = fallback = component != null ? component.getOriginalUseInteractionId() : null;
        if (fallback == null || fallback.isBlank() || USE_GATE_ROOT_ID.equals(fallback)) {
            fallback = DEFAULT_FALLBACK_USE_ROOT;
        }
        return fallback;
    }

    public void onEntityRemoved(Ref<EntityStore> ref, Store<EntityStore> store) {
        if (ref == null || !ref.isValid()) {
            return;
        }
        UUID uuid = this.getUuid(store, ref);
        if (uuid != null && this.animalStates.remove(uuid) != null) {
            this.logDebug("Removed animal tracking for %s", uuid);
        }
    }

    public boolean handleFeed(InteractionContext context, Ref<EntityStore> targetRef, CommandBuffer<EntityStore> buffer) {
        World world;
        String itemId;
        if (!this.isEnabled()) {
            this.logDebug("Breeding disabled", new Object[0]);
            return false;
        }
        if (targetRef == null || !targetRef.isValid()) {
            this.logDebug("Invalid target entity", new Object[0]);
            return false;
        }
        Store store = targetRef.getStore();
        if (store == null) {
            this.logDebug("Target store is null", new Object[0]);
            return false;
        }
        ModelComponent model = (ModelComponent)store.getComponent(targetRef, ModelComponent.getComponentType());
        if (model == null || model.getModel() == null) {
            this.logDebug("Target has no model", new Object[0]);
            return false;
        }
        String modelAssetId = model.getModel().getModelAssetId();
        ModelEntry entry = this.getModelEntry(modelAssetId);
        if (entry == null) {
            this.logDebug("Target is not a tracked animal: %s", modelAssetId);
            return false;
        }
        AnimalDefinition animal = entry.animal;
        ItemStack heldItem = context.getHeldItem();
        String string = itemId = heldItem != null ? heldItem.getItemId() : null;
        if (!animal.isBreedingFood(itemId)) {
            this.logDebug("Wrong food for %s: %s", animal.key, itemId);
            return false;
        }
        UUID animalUuid = this.getUuid((Store<EntityStore>)store, targetRef);
        if (animalUuid == null) {
            this.logDebug("Target UUID missing", new Object[0]);
            return false;
        }
        long now = System.currentTimeMillis();
        AnimalState state = this.animalStates.computeIfAbsent(animalUuid, id -> new AnimalState((UUID)id, animal, modelEntry.isBaby));
        state.ref = targetRef;
        state.animal = animal;
        if (entry.isBaby) {
            return this.handleBabyFeed(context, (Store<EntityStore>)store, targetRef, state, animal, now, buffer);
        }
        if (state.isBaby) {
            this.logDebug("Target is not adult yet", new Object[0]);
            return false;
        }
        long cooldownMillis = this.getCooldownMillis(animal);
        if (now - state.lastBreedTime < cooldownMillis) {
            long remaining = Math.max(0L, cooldownMillis - (now - state.lastBreedTime));
            this.logDebug("Animal on cooldown (%d ms remaining)", remaining);
            return false;
        }
        this.markTamed((Store<EntityStore>)store, targetRef, state, buffer);
        state.inLove = true;
        state.loveStartTime = now;
        this.logDebug("Animal %s (%s) is now in love", animal.key, animalUuid);
        this.consumeHeldItem(context);
        World world2 = world = store.getExternalData() != null ? ((EntityStore)store.getExternalData()).getWorld() : null;
        if (world != null) {
            world.execute(() -> {
                Store worldStore = world.getEntityStore().getStore();
                if (targetRef.isValid()) {
                    this.spawnHearts((Store<EntityStore>)worldStore, targetRef);
                }
                this.attemptBreed((Store<EntityStore>)worldStore, animalUuid, targetRef, animal);
            });
        } else {
            this.logDebug("World missing for %s", animalUuid);
        }
        return true;
    }

    private boolean handleBabyFeed(InteractionContext context, Store<EntityStore> store, Ref<EntityStore> targetRef, AnimalState state, AnimalDefinition animal, long now, CommandBuffer<EntityStore> buffer) {
        World world;
        if (state.birthTime <= 0L) {
            long storedBirthTime = this.getStoredBirthTime(store, targetRef);
            long l = state.birthTime = storedBirthTime > 0L ? storedBirthTime : now;
        }
        if (state.birthTime > now) {
            state.birthTime = now;
        }
        this.markTamed(store, targetRef, state, buffer);
        long growthMillis = this.getGrowthMillis(animal);
        if (growthMillis > 0L) {
            long boostMillis = Math.max(1L, Math.round((double)growthMillis * 0.1));
            state.birthTime = Math.max(0L, state.birthTime - boostMillis);
        }
        this.persistBirthTime(store, targetRef, state.birthTime, buffer);
        this.consumeHeldItem(context);
        World world2 = world = store.getExternalData() != null ? ((EntityStore)store.getExternalData()).getWorld() : null;
        if (world != null) {
            boolean shouldGrowNow = growthMillis == 0L || state.birthTime > 0L && now - state.birthTime >= growthMillis;
            world.execute(() -> {
                Store worldStore = world.getEntityStore().getStore();
                if (!targetRef.isValid()) {
                    return;
                }
                if (shouldGrowNow) {
                    this.transformBabyToAdult((Store<EntityStore>)worldStore, state);
                } else {
                    this.spawnHearts((Store<EntityStore>)worldStore, targetRef);
                }
            });
        } else {
            this.logDebug("World missing for %s", state.uuid);
        }
        return true;
    }

    public void tick(World world) {
        boolean processPending;
        if (!this.isEnabled() || world == null) {
            return;
        }
        long now = System.currentTimeMillis();
        long loveDurationMillis = this.getLoveDurationMillis();
        ArrayList<Ref<EntityStore>> loveRefs = new ArrayList<Ref<EntityStore>>();
        ArrayList<AnimalState> readyBabies = new ArrayList<AnimalState>();
        if (this.shouldCleanup(now)) {
            this.cleanupStaleEntries((Store<EntityStore>)world.getEntityStore().getStore());
            this.lastCleanupMillis = now;
        }
        for (AnimalState state : this.animalStates.values()) {
            if (state.isBaby) {
                long growthMillis = this.getGrowthMillis(state.animal);
                if (state.birthTime <= 0L || now - state.birthTime < growthMillis) continue;
                readyBabies.add(state);
                continue;
            }
            if (state.inLove && now - state.loveStartTime >= loveDurationMillis) {
                state.inLove = false;
                this.logDebug("Love expired for %s (%s)", state.animal.key, state.uuid);
            }
            if (!state.inLove || state.ref == null) continue;
            loveRefs.add(state.ref);
        }
        boolean followNow = this.shouldFollowUpdate(now);
        boolean scanNow = this.shouldInteractionScan(now);
        boolean bl = processPending = !this.pendingInteractionRefs.isEmpty();
        if (loveRefs.isEmpty() && readyBabies.isEmpty() && !followNow && !scanNow && !processPending) {
            return;
        }
        world.execute(() -> {
            Store store = world.getEntityStore().getStore();
            if (processPending) {
                this.processPendingInteractions((Store<EntityStore>)store);
            }
            if (scanNow) {
                int count = this.scanLoadedAnimals((Store<EntityStore>)store);
                this.logDebug("Interaction scan complete: %d entities", count);
            }
            if (followNow) {
                this.applyFollowBehavior((Store<EntityStore>)store);
            }
            for (Ref ref : loveRefs) {
                if (ref == null || !ref.isValid()) continue;
                this.spawnHearts((Store<EntityStore>)store, (Ref<EntityStore>)ref);
            }
            for (AnimalState baby : readyBabies) {
                this.transformBabyToAdult((Store<EntityStore>)store, baby);
            }
        });
    }

    public int scanLoadedAnimals(Store<EntityStore> store) {
        if (!this.isEnabled() || store == null) {
            return 0;
        }
        ComponentType query = ModelComponent.getComponentType();
        ArrayList candidates = new ArrayList();
        store.forEachChunk((Query)query, (chunk, buffer) -> {
            int i = 0;
            while (i < chunk.size()) {
                Ref ref;
                String modelAssetId;
                ModelComponent model = (ModelComponent)chunk.getComponent(i, ModelComponent.getComponentType());
                if (model != null && model.getModel() != null && this.isTrackedModel(modelAssetId = model.getModel().getModelAssetId()) && (ref = chunk.getReferenceTo(i)) != null && ref.isValid()) {
                    candidates.add(new AnimalCandidate((Ref<EntityStore>)ref, modelAssetId));
                }
                ++i;
            }
        });
        for (AnimalCandidate candidate : candidates) {
            this.handleEntity(store, candidate.ref, candidate.modelAssetId);
        }
        return candidates.size();
    }

    private void processPendingInteractions(Store<EntityStore> store) {
        if (store == null || this.pendingInteractionRefs.isEmpty()) {
            return;
        }
        Iterator<Ref<EntityStore>> iterator = this.pendingInteractionRefs.iterator();
        while (iterator.hasNext()) {
            Ref<EntityStore> ref = iterator.next();
            if (ref == null || !ref.isValid()) {
                iterator.remove();
                continue;
            }
            Store refStore = ref.getStore();
            if (refStore == null) {
                iterator.remove();
                continue;
            }
            ModelComponent model = (ModelComponent)refStore.getComponent(ref, ModelComponent.getComponentType());
            if (model == null || model.getModel() == null) {
                iterator.remove();
                continue;
            }
            if (this.getModelEntry(model.getModel().getModelAssetId()) == null) {
                iterator.remove();
                continue;
            }
            Interactions interactions = (Interactions)refStore.getComponent(ref, Interactions.getComponentType());
            if (interactions == null) continue;
            this.attachInteraction((Store<EntityStore>)refStore, ref);
            iterator.remove();
        }
    }

    private void applyFollowBehavior(Store<EntityStore> store) {
        if (store == null || this.animalStates.isEmpty() || this.allBreedingFoods.isEmpty()) {
            return;
        }
        double range = this.getFollowRange();
        double force = this.getFollowForce();
        if (range <= 0.0 || force <= 0.0) {
            return;
        }
        double stopDistance = Math.min(this.getFollowStopDistance(), range);
        double rangeSquared = range * range;
        double stopSquared = stopDistance * stopDistance;
        List<PlayerFollowTarget> players = this.collectFollowPlayers(store);
        if (players.isEmpty()) {
            return;
        }
        for (AnimalState state : this.animalStates.values()) {
            Role role;
            NPCEntity npc;
            Vector3d pos;
            AnimalDefinition animal;
            Ref<EntityStore> ref = state.ref;
            if (ref == null || !ref.isValid() || (animal = state.animal) == null || animal.breedingFoods.isEmpty() || (pos = this.getPosition(store, ref)) == null) continue;
            PlayerFollowTarget target = null;
            double bestDistSquared = 0.0;
            double bestDx = 0.0;
            double bestDz = 0.0;
            for (PlayerFollowTarget player : players) {
                double dz;
                double dx;
                double distSquared;
                if (!animal.isBreedingFood(player.itemId) || (distSquared = (dx = player.x - pos.getX()) * dx + (dz = player.z - pos.getZ()) * dz) > rangeSquared || target != null && !(distSquared < bestDistSquared)) continue;
                target = player;
                bestDistSquared = distSquared;
                bestDx = dx;
                bestDz = dz;
            }
            if (target == null || bestDistSquared <= stopSquared || bestDistSquared <= 1.0E-6 || (npc = (NPCEntity)store.getComponent(ref, NPCEntity.getComponentType())) == null || (role = npc.getRole()) == null) continue;
            double distance = Math.sqrt(bestDistSquared);
            double strength = force;
            if (range > stopDistance) {
                double normalized = (distance - stopDistance) / (range - stopDistance);
                if (normalized < 0.0) {
                    normalized = 0.0;
                } else if (normalized > 1.0) {
                    normalized = 1.0;
                }
                strength *= normalized;
            }
            if (strength <= 0.0) continue;
            double scale = strength / distance;
            Vector3d followForce = new Vector3d(bestDx * scale, 0.0, bestDz * scale);
            role.addForce(followForce, null);
        }
    }

    private List<PlayerFollowTarget> collectFollowPlayers(Store<EntityStore> store) {
        ArrayList<PlayerFollowTarget> players = new ArrayList<PlayerFollowTarget>();
        ComponentType playerQuery = Player.getComponentType();
        store.forEachChunk((Query)playerQuery, (chunk, buffer) -> {
            int i = 0;
            while (i < chunk.size()) {
                TransformComponent transform;
                MovementStatesComponent movementStates;
                String itemId;
                ItemStack heldItem;
                Player player = (Player)chunk.getComponent(i, Player.getComponentType());
                if (player != null && player.getInventory() != null && (heldItem = player.getInventory().getItemInHand()) != null && heldItem.getItemId() != null && this.allBreedingFoods.contains(itemId = heldItem.getItemId().toLowerCase(Locale.ROOT)) && ((movementStates = (MovementStatesComponent)chunk.getComponent(i, MovementStatesComponent.getComponentType())) == null || !movementStates.getMovementStates().sprinting) && (transform = (TransformComponent)chunk.getComponent(i, TransformComponent.getComponentType())) != null && transform.getPosition() != null) {
                    Vector3d position = transform.getPosition();
                    players.add(new PlayerFollowTarget(itemId, position));
                }
                ++i;
            }
        });
        return players;
    }

    private void loadAnimals(ConfigStore.Preset preset) {
        this.allBreedingFoods.clear();
        if (preset == null || preset.animals == null || preset.animals.isEmpty()) {
            ((HytaleLogger.Api)this.logger.atWarning()).log("No animals configured for breeding");
            return;
        }
        for (Map.Entry<String, ConfigStore.Animal> entry : preset.animals.entrySet()) {
            AnimalDefinition definition;
            String normalizedKey;
            String key = entry.getKey();
            if (key == null || key.isBlank()) {
                ((HytaleLogger.Api)this.logger.atWarning()).log("Skipping animal with empty key");
                continue;
            }
            ConfigStore.Animal animal = entry.getValue();
            if (animal == null) {
                this.logDebug("Skipping null animal entry for %s", key);
                continue;
            }
            if (!animal.enabled) {
                this.logDebug("Animal %s disabled", key);
                continue;
            }
            String adultModelId = AnimalBreedingService.normalizeId(animal.modelAssetId);
            String babyModelId = AnimalBreedingService.normalizeId(animal.babyModelAssetId);
            String adultRoleId = AnimalBreedingService.normalizeId(animal.adultNpcRoleId);
            String babyRoleId = AnimalBreedingService.normalizeId(animal.babyNpcRoleId);
            if (adultModelId == null || babyModelId == null || adultRoleId == null || babyRoleId == null) {
                ((HytaleLogger.Api)this.logger.atWarning()).log("Skipping animal %s due to missing IDs", (Object)key);
                continue;
            }
            HashSet<String> foods = new HashSet<String>();
            if (animal.breedingFoods != null) {
                for (String food : animal.breedingFoods) {
                    if (food == null || food.isBlank()) continue;
                    String normalized = food.toLowerCase(Locale.ROOT);
                    foods.add(normalized);
                    this.allBreedingFoods.add(normalized);
                }
            }
            if (foods.isEmpty()) {
                ((HytaleLogger.Api)this.logger.atWarning()).log("Animal %s has no breeding foods configured", (Object)key);
            }
            if (this.animalsByKey.putIfAbsent(normalizedKey = key.trim().toLowerCase(Locale.ROOT), definition = new AnimalDefinition(key.trim(), adultRoleId, babyRoleId, foods, animal.growthTimeSeconds, animal.breedCooldownSeconds)) != null) {
                ((HytaleLogger.Api)this.logger.atWarning()).log("Duplicate animal key %s; skipping", (Object)key);
                continue;
            }
            String adultModelKey = adultModelId.toLowerCase(Locale.ROOT);
            String babyModelKey = babyModelId.toLowerCase(Locale.ROOT);
            if (this.modelIndex.putIfAbsent(adultModelKey, new ModelEntry(definition, false)) != null) {
                ((HytaleLogger.Api)this.logger.atWarning()).log("Duplicate model asset id %s; skipping", (Object)adultModelId);
            }
            if (this.modelIndex.putIfAbsent(babyModelKey, new ModelEntry(definition, true)) == null) continue;
            ((HytaleLogger.Api)this.logger.atWarning()).log("Duplicate model asset id %s; skipping", (Object)babyModelId);
        }
        if (this.animalsByKey.isEmpty()) {
            ((HytaleLogger.Api)this.logger.atWarning()).log("No enabled animals configured for breeding");
        } else {
            ((HytaleLogger.Api)this.logger.atInfo()).log("Loaded %d breeding animals", this.animalsByKey.size());
        }
    }

    private void attemptBreed(Store<EntityStore> store, UUID animalUuid, Ref<EntityStore> targetRef, AnimalDefinition animal) {
        Vector3d pos = this.getPosition(store, targetRef);
        if (pos == null) {
            this.logDebug("Animal %s position missing", animalUuid);
            return;
        }
        AnimalState self = this.animalStates.get(animalUuid);
        if (self == null || !self.inLove || self.isBaby) {
            return;
        }
        double maxDistance = this.getBreedingDistance();
        for (AnimalState other : this.animalStates.values()) {
            long now;
            double distance;
            Vector3d otherPos;
            if (other.uuid.equals(animalUuid) || other.isBaby || !other.inLove || other.ref == null || other.animal != animal || !other.ref.isValid() || (otherPos = this.getPosition(store, other.ref)) == null || (distance = pos.distanceTo(otherPos)) > maxDistance) continue;
            self.inLove = false;
            other.inLove = false;
            self.lastBreedTime = now = System.currentTimeMillis();
            other.lastBreedTime = now;
            this.persistLastBreedTime(store, self.ref, now, null);
            this.persistLastBreedTime(store, other.ref, now, null);
            Vector3d midpoint = new Vector3d((pos.getX() + otherPos.getX()) / 2.0, (pos.getY() + otherPos.getY()) / 2.0, (pos.getZ() + otherPos.getZ()) / 2.0);
            ((HytaleLogger.Api)this.logger.atInfo()).log("Breeding success for %s at %.2f", (Object)animal.key, distance);
            this.spawnBaby(store, animal, midpoint);
            return;
        }
    }

    private void spawnBaby(Store<EntityStore> store, AnimalDefinition animal, Vector3d position) {
        NPCPlugin npcPlugin = NPCPlugin.get();
        int roleIndex = npcPlugin.getIndex(animal.babyRoleId);
        if (roleIndex < 0) {
            ((HytaleLogger.Api)this.logger.atWarning()).log("Unknown baby NPC role for %s: %s", (Object)animal.key, (Object)animal.babyRoleId);
            return;
        }
        Pair result = npcPlugin.spawnEntity(store, roleIndex, position, new Vector3f(0.0f, 0.0f, 0.0f), null, null);
        if (result == null) {
            ((HytaleLogger.Api)this.logger.atWarning()).log("Failed to spawn baby for %s", (Object)animal.key);
            return;
        }
        Ref ref = (Ref)result.first();
        UUID uuid = this.getUuid(store, (Ref<EntityStore>)ref);
        if (uuid == null) {
            ((HytaleLogger.Api)this.logger.atWarning()).log("Spawned baby for %s missing UUID", (Object)animal.key);
            return;
        }
        AnimalState baby = new AnimalState(uuid, animal, true);
        baby.birthTime = System.currentTimeMillis();
        baby.ref = ref;
        baby.tamed = true;
        this.animalStates.put(uuid, baby);
        this.markTamed(store, (Ref<EntityStore>)ref, baby);
        this.persistBirthTime(store, (Ref<EntityStore>)ref, baby.birthTime, null);
        ((HytaleLogger.Api)this.logger.atInfo()).log("Spawned baby for %s (%s) at %.2f, %.2f, %.2f", (Object)animal.key, (Object)uuid, (Object)position.getX(), (Object)position.getY(), (Object)position.getZ());
    }

    private void transformBabyToAdult(Store<EntityStore> store, AnimalState baby) {
        if (baby.ref == null || !baby.ref.isValid()) {
            this.logDebug("Baby for %s missing ref during growth", baby.animal.key);
            this.animalStates.remove(baby.uuid);
            return;
        }
        Vector3d pos = this.getPosition(store, baby.ref);
        if (pos == null) {
            this.logDebug("Baby for %s missing position during growth", baby.animal.key);
            this.animalStates.remove(baby.uuid);
            return;
        }
        store.removeEntity(baby.ref, RemoveReason.REMOVE);
        NPCPlugin npcPlugin = NPCPlugin.get();
        int roleIndex = npcPlugin.getIndex(baby.animal.adultRoleId);
        if (roleIndex < 0) {
            ((HytaleLogger.Api)this.logger.atWarning()).log("Unknown adult NPC role for %s: %s", (Object)baby.animal.key, (Object)baby.animal.adultRoleId);
            this.animalStates.remove(baby.uuid);
            return;
        }
        Pair result = npcPlugin.spawnEntity(store, roleIndex, pos, new Vector3f(0.0f, 0.0f, 0.0f), null, null);
        if (result != null) {
            ((HytaleLogger.Api)this.logger.atInfo()).log("Baby for %s (%s) grew into adult at %.2f, %.2f, %.2f", (Object)baby.animal.key, (Object)baby.uuid, (Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ());
            Ref adultRef = (Ref)result.first();
            this.attachInteraction(store, (Ref<EntityStore>)adultRef);
            if (baby.tamed) {
                UUID adultUuid = this.getUuid(store, (Ref<EntityStore>)adultRef);
                if (adultUuid != null) {
                    AnimalState adultState = new AnimalState(adultUuid, baby.animal, false);
                    adultState.ref = adultRef;
                    adultState.tamed = true;
                    this.animalStates.put(adultUuid, adultState);
                    this.markTamed(store, (Ref<EntityStore>)adultRef, adultState);
                } else {
                    ((HytaleLogger.Api)this.logger.atWarning()).log("Grown adult for %s missing UUID", (Object)baby.animal.key);
                }
            }
        } else {
            ((HytaleLogger.Api)this.logger.atWarning()).log("Failed to spawn adult for %s (%s)", (Object)baby.animal.key, (Object)baby.uuid);
        }
        this.animalStates.remove(baby.uuid);
    }

    private void registerBaby(Store<EntityStore> store, Ref<EntityStore> ref, AnimalDefinition animal) {
        UUID uuid = this.getUuid(store, ref);
        if (uuid == null) {
            ((HytaleLogger.Api)this.logger.atWarning()).log("Unable to register baby for %s: missing UUID", (Object)animal.key);
            return;
        }
        boolean hasTamed = this.hasTamedComponent(store, ref);
        long storedBirthTime = this.getStoredBirthTime(store, ref);
        AnimalState existing = this.animalStates.get(uuid);
        if (existing != null) {
            existing.ref = ref;
            existing.animal = animal;
            if (hasTamed && !existing.tamed) {
                this.markTamed(store, ref, existing);
            }
            if (storedBirthTime > 0L) {
                existing.birthTime = storedBirthTime;
            } else if (existing.birthTime <= 0L) {
                existing.birthTime = System.currentTimeMillis();
                if (existing.tamed) {
                    this.persistBirthTime(store, ref, existing.birthTime, null);
                }
            }
            return;
        }
        AnimalState baby = new AnimalState(uuid, animal, true);
        baby.birthTime = storedBirthTime > 0L ? storedBirthTime : System.currentTimeMillis();
        baby.ref = ref;
        baby.tamed = hasTamed;
        this.animalStates.put(uuid, baby);
        if (baby.tamed) {
            this.markTamed(store, ref, baby);
            if (storedBirthTime <= 0L) {
                this.persistBirthTime(store, ref, baby.birthTime, null);
            }
            ((HytaleLogger.Api)this.logger.atInfo()).log("Registered tamed baby for %s (%s) for growth tracking", (Object)animal.key, (Object)uuid);
        } else {
            this.logDebug("Registered baby for %s (%s) for growth tracking", animal.key, uuid);
        }
    }

    private void registerAdult(Store<EntityStore> store, Ref<EntityStore> ref, AnimalDefinition animal) {
        UUID uuid = this.getUuid(store, ref);
        if (uuid == null) {
            ((HytaleLogger.Api)this.logger.atWarning()).log("Unable to register adult for %s: missing UUID", (Object)animal.key);
            return;
        }
        AnimalState existing = this.animalStates.get(uuid);
        if (existing != null) {
            existing.ref = ref;
            existing.animal = animal;
            return;
        }
        AnimalState adult = new AnimalState(uuid, animal, false);
        adult.ref = ref;
        this.animalStates.put(uuid, adult);
        this.logDebug("Registered adult for %s (%s) for follow tracking", animal.key, uuid);
    }

    private void ensureTamedState(Store<EntityStore> store, Ref<EntityStore> ref, AnimalDefinition animal, boolean isBaby) {
        UUID uuid = this.getUuid(store, ref);
        if (uuid == null) {
            return;
        }
        AnimalState existing = this.animalStates.get(uuid);
        if (existing != null) {
            existing.ref = ref;
            existing.animal = animal;
            existing.tamed = true;
            long storedBreedTime = this.getStoredLastBreedTime(store, ref);
            if (storedBreedTime > 0L) {
                existing.lastBreedTime = storedBreedTime;
            }
            this.clearSpawnTracking(store, ref, null);
            return;
        }
        AnimalState created = new AnimalState(uuid, animal, isBaby);
        created.ref = ref;
        created.tamed = true;
        long storedBreedTime = this.getStoredLastBreedTime(store, ref);
        if (storedBreedTime > 0L) {
            created.lastBreedTime = storedBreedTime;
        }
        this.animalStates.put(uuid, created);
        this.clearSpawnTracking(store, ref, null);
    }

    private boolean hasTamedComponent(Store<EntityStore> store, Ref<EntityStore> ref) {
        if (this.tamedComponentType == null || store == null || ref == null) {
            return false;
        }
        return store.getComponent(ref, this.tamedComponentType) != null;
    }

    private void markTamed(Store<EntityStore> store, Ref<EntityStore> ref, AnimalState state, CommandBuffer<EntityStore> buffer) {
        boolean wasTamed;
        if (this.tamedComponentType == null || ref == null || !ref.isValid()) {
            return;
        }
        this.clearSpawnTracking(store, ref, buffer);
        boolean bl = wasTamed = state != null && state.tamed;
        if (buffer != null) {
            buffer.ensureComponent(ref, this.tamedComponentType);
        } else {
            World world;
            World world2 = world = store != null && store.getExternalData() != null ? ((EntityStore)store.getExternalData()).getWorld() : null;
            if (store != null && world != null) {
                world.execute(() -> {
                    if (ref.isValid()) {
                        store.ensureComponent(ref, this.tamedComponentType);
                    }
                });
            } else {
                this.logDebug("Skipping tamed component attach; command buffer missing for %s", ref);
            }
        }
        if (state != null) {
            state.tamed = true;
        }
        if (!wasTamed && state != null) {
            ((HytaleLogger.Api)this.logger.atInfo()).log("Tamed %s (%s)", (Object)state.animal.key, (Object)state.uuid);
        }
    }

    private void markTamed(Store<EntityStore> store, Ref<EntityStore> ref, AnimalState state) {
        if (this.tamedComponentType == null || store == null || ref == null || !ref.isValid()) {
            return;
        }
        this.clearSpawnTracking(store, ref, null);
        boolean wasTamed = state != null && state.tamed;
        store.ensureComponent(ref, this.tamedComponentType);
        if (state != null) {
            state.tamed = true;
        }
        if (!wasTamed && state != null) {
            ((HytaleLogger.Api)this.logger.atInfo()).log("Tamed %s (%s)", (Object)state.animal.key, (Object)state.uuid);
        }
    }

    private void cleanupStaleEntries(Store<EntityStore> store) {
        if (store == null) {
            return;
        }
        this.animalStates.entrySet().removeIf(entry -> {
            AnimalState state = (AnimalState)entry.getValue();
            if (state.ref != null && !state.ref.isValid()) {
                this.logDebug("Cleaning up stale tracking for %s", entry.getKey());
                return true;
            }
            return false;
        });
    }

    private boolean shouldCleanup(long nowMillis) {
        double seconds;
        double d = seconds = this.config != null && this.config.global != null ? this.config.global.cleanupIntervalSeconds : 5.0;
        if (seconds <= 0.0) {
            return false;
        }
        long intervalMillis = (long)(seconds * 1000.0);
        return nowMillis - this.lastCleanupMillis >= intervalMillis;
    }

    private boolean shouldFollowUpdate(long nowMillis) {
        if (!this.isFollowEnabled()) {
            return false;
        }
        if (this.allBreedingFoods.isEmpty() || this.animalStates.isEmpty()) {
            return false;
        }
        long intervalMillis = this.getFollowIntervalMillis();
        if (intervalMillis <= 0L) {
            return true;
        }
        if (nowMillis - this.lastFollowUpdateMillis < intervalMillis) {
            return false;
        }
        this.lastFollowUpdateMillis = nowMillis;
        return true;
    }

    private boolean shouldInteractionScan(long nowMillis) {
        double seconds;
        double d = seconds = this.config != null && this.config.global != null ? this.config.global.interactionScanIntervalSeconds : 5.0;
        if (seconds <= 0.0) {
            return false;
        }
        long intervalMillis = Math.max(1L, (long)(seconds * 1000.0));
        if (nowMillis - this.lastInteractionScanMillis < intervalMillis) {
            return false;
        }
        this.lastInteractionScanMillis = nowMillis;
        return true;
    }

    private void clearSpawnTracking(Store<EntityStore> store, Ref<EntityStore> ref, CommandBuffer<EntityStore> buffer) {
        if (ref == null || !ref.isValid()) {
            return;
        }
        if (buffer != null) {
            buffer.run(_store -> this.clearSpawnTracking((Store<EntityStore>)_store, ref));
            return;
        }
        this.clearSpawnTracking(store, ref);
    }

    private void clearSpawnTracking(Store<EntityStore> store, Ref<EntityStore> ref) {
        WorldSpawnData worldSpawnData;
        if (store == null) {
            return;
        }
        NPCEntity npc = (NPCEntity)store.getComponent(ref, NPCEntity.getComponentType());
        if (npc == null) {
            return;
        }
        int environment = npc.getEnvironment();
        int roleIndex = npc.getRoleIndex();
        boolean wasTracked = npc.updateSpawnTrackingState(false);
        if (wasTracked && environment != Integer.MIN_VALUE && roleIndex != Integer.MIN_VALUE && (worldSpawnData = (WorldSpawnData)store.getResource(WorldSpawnData.getResourceType())) != null) {
            worldSpawnData.untrackNPC(environment, roleIndex, 1);
            this.logDebug("Untracked tamed %s from spawn stats (env=%d role=%d)", ref, environment, roleIndex);
        }
        npc.setEnvironment(Integer.MIN_VALUE);
        npc.setSpawnConfiguration(Integer.MIN_VALUE);
        this.logDebug("Cleared spawn tracking for tamed %s", ref);
    }

    private void persistLastBreedTime(Store<EntityStore> store, Ref<EntityStore> ref, long lastBreedTime, CommandBuffer<EntityStore> buffer) {
        this.updateTamedComponent(store, ref, buffer, component -> component.setLastBreedTimeMillis(lastBreedTime));
    }

    private void persistBirthTime(Store<EntityStore> store, Ref<EntityStore> ref, long birthTime, CommandBuffer<EntityStore> buffer) {
        this.updateTamedComponent(store, ref, buffer, component -> component.setBirthTimeMillis(birthTime));
    }

    private long getStoredLastBreedTime(Store<EntityStore> store, Ref<EntityStore> ref) {
        if (store == null || ref == null) {
            return 0L;
        }
        TamedAnimalComponent component = (TamedAnimalComponent)store.getComponent(ref, this.tamedComponentType);
        return component != null ? component.getLastBreedTimeMillis() : 0L;
    }

    private long getStoredBirthTime(Store<EntityStore> store, Ref<EntityStore> ref) {
        if (store == null || ref == null) {
            return 0L;
        }
        TamedAnimalComponent component = (TamedAnimalComponent)store.getComponent(ref, this.tamedComponentType);
        return component != null ? component.getBirthTimeMillis() : 0L;
    }

    private void updateTamedComponent(Store<EntityStore> store, Ref<EntityStore> ref, CommandBuffer<EntityStore> buffer, Consumer<TamedAnimalComponent> updater) {
        if (this.tamedComponentType == null || updater == null || ref == null || !ref.isValid()) {
            return;
        }
        if (buffer != null) {
            buffer.run(_store -> this.updateTamedComponent((Store<EntityStore>)_store, ref, updater));
            return;
        }
        this.updateTamedComponent(store, ref, updater);
    }

    private void updateTamedComponent(Store<EntityStore> store, Ref<EntityStore> ref, Consumer<TamedAnimalComponent> updater) {
        if (store == null || updater == null || ref == null || !ref.isValid()) {
            return;
        }
        TamedAnimalComponent component = (TamedAnimalComponent)store.getComponent(ref, this.tamedComponentType);
        if (component == null) {
            component = new TamedAnimalComponent();
        }
        updater.accept(component);
        store.putComponent(ref, this.tamedComponentType, (Component)component);
    }

    private void consumeHeldItem(InteractionContext context) {
        if (context.getHeldItemContainer() == null || context.getHeldItem() == null) {
            this.logDebug("No held item to consume", new Object[0]);
            return;
        }
        context.getHeldItemContainer().removeItemStackFromSlot((short)context.getHeldItemSlot(), context.getHeldItem(), 1);
    }

    private void spawnHearts(Store<EntityStore> store, Ref<EntityStore> ref) {
        Vector3d pos = this.getPosition(store, ref);
        if (pos == null) {
            return;
        }
        Vector3d heartsPos = new Vector3d(pos.getX(), pos.getY() + 1.5, pos.getZ());
        ParticleUtil.spawnParticleEffect((String)HEARTS_PARTICLE, (Vector3d)heartsPos, store);
    }

    private Vector3d getPosition(Store<EntityStore> store, Ref<EntityStore> ref) {
        TransformComponent transform = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
        return transform != null ? transform.getPosition() : null;
    }

    private UUID getUuid(Store<EntityStore> store, Ref<EntityStore> ref) {
        if (ref == null || store == null) {
            return null;
        }
        UUIDComponent uuidComp = (UUIDComponent)store.getComponent(ref, UUIDComponent.getComponentType());
        return uuidComp != null ? uuidComp.getUuid() : null;
    }

    private ModelEntry getModelEntry(String modelAssetId) {
        if (modelAssetId == null) {
            return null;
        }
        return this.modelIndex.get(modelAssetId.toLowerCase(Locale.ROOT));
    }

    private void ensureInteractionGateComponent(Store<EntityStore> store, Ref<EntityStore> ref, String currentUse) {
        String original;
        boolean shouldStore;
        if (this.interactionComponentType == null || store == null || ref == null) {
            return;
        }
        AnimalHusbandryInteractionComponent component = (AnimalHusbandryInteractionComponent)store.getComponent(ref, this.interactionComponentType);
        boolean bl = shouldStore = component == null;
        if (component == null) {
            component = new AnimalHusbandryInteractionComponent();
        }
        if ((original = component.getOriginalUseInteractionId()) == null || original.isBlank() || USE_GATE_ROOT_ID.equals(original)) {
            String fallback = currentUse;
            if (fallback == null || fallback.isBlank() || USE_GATE_ROOT_ID.equals(fallback)) {
                fallback = DEFAULT_FALLBACK_USE_ROOT;
            }
            if (!fallback.equals(original)) {
                component.setOriginalUseInteractionId(fallback);
                shouldStore = true;
            }
        }
        if (shouldStore) {
            store.putComponent(ref, this.interactionComponentType, (Component)component);
        }
    }

    private long getCooldownMillis(AnimalDefinition animal) {
        double seconds = animal.breedCooldownSeconds;
        double multiplier = this.config != null && this.config.global != null ? this.config.global.cooldownDurationMultiplier : 1.0;
        return Math.max(0L, (long)(seconds * 1000.0 * multiplier));
    }

    private long getGrowthMillis(AnimalDefinition animal) {
        double seconds = animal.growthTimeSeconds;
        double multiplier = this.config != null && this.config.global != null ? this.config.global.growthDurationMultiplier : 1.0;
        return Math.max(0L, (long)(seconds * 1000.0 * multiplier));
    }

    private long getLoveDurationMillis() {
        double seconds = this.config != null && this.config.global != null ? this.config.global.loveDurationSeconds : 30.0;
        return Math.max(0L, (long)(seconds * 1000.0));
    }

    private double getBreedingDistance() {
        double distance = this.config != null && this.config.global != null ? this.config.global.breedingDistance : 5.0;
        return Math.max(0.0, distance);
    }

    private boolean isFollowEnabled() {
        return this.config != null && this.config.global != null && Boolean.TRUE.equals(this.config.global.followEnabled);
    }

    private double getFollowRange() {
        double range = this.config != null && this.config.global != null ? this.config.global.followRange : 10.0;
        return Math.max(0.0, range);
    }

    private double getFollowStopDistance() {
        double distance = this.config != null && this.config.global != null ? this.config.global.followStopDistance : 2.0;
        return Math.max(0.0, distance);
    }

    private double getFollowForce() {
        double force = this.config != null && this.config.global != null ? this.config.global.followForce : 0.08;
        return Math.max(0.0, force);
    }

    private long getFollowIntervalMillis() {
        double seconds;
        double d = seconds = this.config != null && this.config.global != null ? this.config.global.followUpdateIntervalSeconds : 0.25;
        if (seconds <= 0.0) {
            return 0L;
        }
        return Math.max(1L, (long)(seconds * 1000.0));
    }

    private void logDebug(String message, Object ... args) {
        if (this.config != null && this.config.debug) {
            ((HytaleLogger.Api)this.logger.atInfo()).log(message, (Object)args);
        }
    }

    private static String normalizeId(String value) {
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    private static final class AnimalCandidate {
        private final Ref<EntityStore> ref;
        private final String modelAssetId;

        private AnimalCandidate(Ref<EntityStore> ref, String modelAssetId) {
            this.ref = ref;
            this.modelAssetId = modelAssetId;
        }
    }

    private static final class AnimalDefinition {
        private final String key;
        private final String adultRoleId;
        private final String babyRoleId;
        private final Set<String> breedingFoods;
        private final double growthTimeSeconds;
        private final double breedCooldownSeconds;

        private AnimalDefinition(String key, String adultRoleId, String babyRoleId, Set<String> breedingFoods, double growthTimeSeconds, double breedCooldownSeconds) {
            this.key = key;
            this.adultRoleId = adultRoleId;
            this.babyRoleId = babyRoleId;
            this.breedingFoods = breedingFoods;
            this.growthTimeSeconds = growthTimeSeconds;
            this.breedCooldownSeconds = breedCooldownSeconds;
        }

        private boolean isBreedingFood(String itemId) {
            if (itemId == null) {
                return false;
            }
            return this.breedingFoods.contains(itemId.toLowerCase(Locale.ROOT));
        }
    }

    private static final class AnimalState {
        private final UUID uuid;
        private final boolean isBaby;
        private volatile AnimalDefinition animal;
        private volatile boolean inLove;
        private volatile long loveStartTime;
        private volatile long lastBreedTime;
        private volatile long birthTime;
        private volatile Ref<EntityStore> ref;
        private volatile boolean tamed;

        private AnimalState(UUID uuid, AnimalDefinition animal, boolean isBaby) {
            this.uuid = uuid;
            this.animal = animal;
            this.isBaby = isBaby;
        }
    }

    private static final class ModelEntry {
        private final AnimalDefinition animal;
        private final boolean isBaby;

        private ModelEntry(AnimalDefinition animal, boolean isBaby) {
            this.animal = animal;
            this.isBaby = isBaby;
        }
    }

    private static final class PlayerFollowTarget {
        private final String itemId;
        private final double x;
        private final double y;
        private final double z;

        private PlayerFollowTarget(String itemId, Vector3d position) {
            this.itemId = itemId;
            this.x = position.getX();
            this.y = position.getY();
            this.z = position.getZ();
        }
    }
}

