/*
 * Decompiled with CFR 0.152.
 */
package dev.lnkr.animalhusbandry.breeding;

import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.ComponentType;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.tick.EntityTickingSystem;
import com.hypixel.hytale.server.core.entity.UUIDComponent;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entity.component.ModelComponent;
import com.hypixel.hytale.server.core.modules.entity.component.NewSpawnComponent;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import dev.lnkr.animalhusbandry.AnimalHusbandry;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public final class AnimalSpawnSystem
extends EntityTickingSystem<EntityStore> {
    private static final ComponentType<EntityStore, ModelComponent> MODEL_TYPE = ModelComponent.getComponentType();
    private static final ComponentType<EntityStore, NewSpawnComponent> SPAWN_TYPE = NewSpawnComponent.getComponentType();
    private static final ComponentType<EntityStore, UUIDComponent> UUID_TYPE = UUIDComponent.getComponentType();
    private static final ComponentType<EntityStore, Player> PLAYER_TYPE = Player.getComponentType();
    private final AnimalHusbandry plugin;
    private final Set<UUID> processed = ConcurrentHashMap.newKeySet();

    public AnimalSpawnSystem(AnimalHusbandry plugin) {
        this.plugin = plugin;
    }

    public void tick(float deltaTime, int entityIndex, ArchetypeChunk<EntityStore> chunk, Store<EntityStore> store, CommandBuffer<EntityStore> buffer) {
        UUID uuid;
        if (chunk.getComponent(entityIndex, PLAYER_TYPE) != null) {
            return;
        }
        ModelComponent model = (ModelComponent)chunk.getComponent(entityIndex, MODEL_TYPE);
        if (model == null || model.getModel() == null) {
            return;
        }
        String modelAssetId = model.getModel().getModelAssetId();
        if (modelAssetId == null || !this.plugin.isTrackedModel(modelAssetId)) {
            return;
        }
        Ref ref = chunk.getReferenceTo(entityIndex);
        if (ref == null || !ref.isValid()) {
            return;
        }
        UUIDComponent uuidComp = (UUIDComponent)chunk.getComponent(entityIndex, UUID_TYPE);
        UUID uUID = uuid = uuidComp != null ? uuidComp.getUuid() : null;
        if (uuid == null || this.processed.contains(uuid)) {
            return;
        }
        this.processed.add(uuid);
        this.plugin.onAnimalSpawn((Ref<EntityStore>)ref, modelAssetId);
    }

    public Query<EntityStore> getQuery() {
        return Query.and((Query[])new Query[]{SPAWN_TYPE, MODEL_TYPE});
    }
}

