/*
 * Decompiled with CFR 0.152.
 */
package dev.lnkr.animalhusbandry.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.hypixel.hytale.logger.HytaleLogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public final class ConfigStore {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE = "config.json";
    private static final String PRESETS_DIR = "presets";
    private static final String DEFAULT_PRESET_NAME = "default";
    private static final String DEFAULT_CONFIG_RESOURCE = "/defaults/config.json";
    private static final String DEFAULT_PRESET_RESOURCE = "/defaults/presets/default.json";
    private static final Pattern PRESET_NAME = Pattern.compile("^[A-Za-z0-9_-]{1,64}$");

    private ConfigStore() {
    }

    public static LoadedConfig loadOrCreate(Path dataDir, HytaleLogger logger) {
        Path resolvedPresetPath;
        try {
            Files.createDirectories(dataDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Failed to create data directory: %s", (Object)dataDir);
        }
        Path configPath = dataDir.resolve(CONFIG_FILE);
        Path presetDir = dataDir.resolve(PRESETS_DIR);
        Config defaultConfig = ConfigStore.readResourceJson(DEFAULT_CONFIG_RESOURCE, Config.class, logger, new Config());
        ConfigStore.normalizeConfig(defaultConfig, null);
        Preset defaultPreset = ConfigStore.readResourceJson(DEFAULT_PRESET_RESOURCE, Preset.class, logger, new Preset());
        ConfigStore.normalizePreset(defaultPreset);
        if (!Files.exists(configPath, new LinkOption[0])) {
            ConfigStore.writeJson(configPath, defaultConfig, logger);
        }
        Config config = ConfigStore.readJson(configPath, Config.class, logger, defaultConfig);
        ConfigStore.normalizeConfig(config, defaultConfig);
        String presetName = ConfigStore.normalizePresetName(config.preset);
        if (presetName == null) {
            ((HytaleLogger.Api)logger.atWarning()).log("Invalid preset name '%s'. Falling back to %s.", (Object)config.preset, (Object)DEFAULT_PRESET_NAME);
            config.preset = presetName = DEFAULT_PRESET_NAME;
        }
        if (!Files.exists(resolvedPresetPath = presetDir.resolve(presetName + ".json"), new LinkOption[0])) {
            ((HytaleLogger.Api)logger.atWarning()).log("Preset '%s' missing. Creating from defaults.", (Object)presetName);
            ConfigStore.writeJson(resolvedPresetPath, defaultPreset, logger);
        }
        Preset preset = ConfigStore.readJson(resolvedPresetPath, Preset.class, logger, defaultPreset);
        ConfigStore.normalizePreset(preset);
        return new LoadedConfig(config, preset);
    }

    private static void writeJson(Path path, Object value, HytaleLogger logger) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)GSON.toJson(value), StandardCharsets.UTF_8, new OpenOption[0]);
            ((HytaleLogger.Api)logger.atInfo()).log("Wrote %s", (Object)path);
        }
        catch (IOException e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Failed to write %s", (Object)path);
        }
    }

    private static <T> T readJson(Path path, Class<T> type, HytaleLogger logger, T fallback) {
        try {
            String json = Files.readString(path, StandardCharsets.UTF_8);
            Object parsed = GSON.fromJson(json, type);
            if (parsed == null) {
                throw new JsonParseException("Parsed null for " + String.valueOf(path));
            }
            return (T)parsed;
        }
        catch (JsonParseException | IOException e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)logger.atWarning()).withCause(e)).log("Failed to read %s, using defaults.", (Object)path);
            return fallback;
        }
    }

    private static <T> T readResourceJson(String resourcePath, Class<T> type, HytaleLogger logger, T fallback) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream stream = ConfigStore.class.getResourceAsStream(resourcePath);){
                if (stream == null) {
                    ((HytaleLogger.Api)logger.atWarning()).log("Missing resource %s, using fallback defaults.", (Object)resourcePath);
                    return fallback;
                }
                String json = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                Object parsed = GSON.fromJson(json, type);
                if (parsed == null) {
                    throw new JsonParseException("Parsed null for resource " + resourcePath);
                }
                return (T)parsed;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonParseException | IOException e) {
            ((HytaleLogger.Api)((HytaleLogger.Api)logger.atWarning()).withCause(e)).log("Failed to read resource %s, using fallback defaults.", (Object)resourcePath);
            return fallback;
        }
    }

    private static void normalizeConfig(Config config, Config defaults) {
        if (config == null) {
            return;
        }
        if (config.preset == null || config.preset.isBlank()) {
            String string = config.preset = defaults != null && defaults.preset != null ? defaults.preset : DEFAULT_PRESET_NAME;
        }
        if (config.global == null) {
            Global global = config.global = defaults != null ? defaults.global : null;
        }
        if (config.global == null) {
            config.global = new Global();
        }
        if (config.global.breedingDistance <= 0.0) {
            double d = config.global.breedingDistance = defaults != null && defaults.global != null ? defaults.global.breedingDistance : 5.0;
        }
        if (config.global.loveDurationSeconds <= 0.0) {
            double d = config.global.loveDurationSeconds = defaults != null && defaults.global != null ? defaults.global.loveDurationSeconds : 30.0;
        }
        if (config.global.growthDurationMultiplier <= 0.0 && config.global.growthMultiplier > 0.0) {
            config.global.growthDurationMultiplier = config.global.growthMultiplier;
        }
        if (config.global.cooldownDurationMultiplier <= 0.0 && config.global.cooldownMultiplier > 0.0) {
            config.global.cooldownDurationMultiplier = config.global.cooldownMultiplier;
        }
        if (config.global.growthDurationMultiplier <= 0.0) {
            double d = config.global.growthDurationMultiplier = defaults != null && defaults.global != null ? defaults.global.growthDurationMultiplier : 1.0;
        }
        if (config.global.cooldownDurationMultiplier <= 0.0) {
            double d = config.global.cooldownDurationMultiplier = defaults != null && defaults.global != null ? defaults.global.cooldownDurationMultiplier : 1.0;
        }
        if (config.global.tickIntervalSeconds <= 0.0) {
            double d = config.global.tickIntervalSeconds = defaults != null && defaults.global != null ? defaults.global.tickIntervalSeconds : 1.0;
        }
        if (config.global.cleanupIntervalSeconds <= 0.0) {
            double d = config.global.cleanupIntervalSeconds = defaults != null && defaults.global != null ? defaults.global.cleanupIntervalSeconds : 5.0;
        }
        if (config.global.followEnabled == null) {
            Boolean bl = config.global.followEnabled = defaults != null && defaults.global != null ? defaults.global.followEnabled : Boolean.FALSE;
        }
        if (config.global.followRange <= 0.0) {
            double d = config.global.followRange = defaults != null && defaults.global != null ? defaults.global.followRange : 10.0;
        }
        if (config.global.followStopDistance <= 0.0) {
            double d = config.global.followStopDistance = defaults != null && defaults.global != null ? defaults.global.followStopDistance : 2.0;
        }
        if (config.global.followForce <= 0.0) {
            double d = config.global.followForce = defaults != null && defaults.global != null ? defaults.global.followForce : 0.08;
        }
        if (config.global.followUpdateIntervalSeconds <= 0.0) {
            double d = config.global.followUpdateIntervalSeconds = defaults != null && defaults.global != null ? defaults.global.followUpdateIntervalSeconds : 0.25;
        }
        if (config.global.interactionScanIntervalSeconds <= 0.0) {
            config.global.interactionScanIntervalSeconds = defaults != null && defaults.global != null ? defaults.global.interactionScanIntervalSeconds : 5.0;
        }
    }

    private static void normalizePreset(Preset preset) {
        if (preset.animals == null) {
            preset.animals = new HashMap<String, Animal>();
        }
    }

    private static String normalizePresetName(String name) {
        if (name == null) {
            return null;
        }
        String trimmed = name.trim();
        if (!PRESET_NAME.matcher(trimmed).matches()) {
            return null;
        }
        return trimmed.toLowerCase(Locale.ROOT);
    }

    public static final class Animal {
        public boolean enabled;
        public String modelAssetId;
        public String adultNpcRoleId;
        public String babyModelAssetId;
        public String babyNpcRoleId;
        public List<String> breedingFoods;
        public double growthTimeSeconds;
        public double breedCooldownSeconds;
    }

    public static final class Config {
        public boolean debug;
        public String preset;
        public Global global;
    }

    public static final class Global {
        public double breedingDistance;
        public double loveDurationSeconds;
        public double growthDurationMultiplier;
        public double cooldownDurationMultiplier;
        public double tickIntervalSeconds;
        public double cleanupIntervalSeconds;
        public double growthMultiplier;
        public double cooldownMultiplier;
        public Boolean followEnabled;
        public double followRange;
        public double followStopDistance;
        public double followForce;
        public double followUpdateIntervalSeconds;
        public double interactionScanIntervalSeconds;
    }

    public static final class LoadedConfig {
        public final Config config;
        public final Preset preset;

        public LoadedConfig(Config config, Preset preset) {
            this.config = config;
            this.preset = preset;
        }
    }

    public static final class Preset {
        public Map<String, Animal> animals;
    }
}

